% This benchmark script test the decomposition of an image using Matching
% Pursuit and geometrically optimized MP. 
% The dictionary used is made of translated, rotated and anisotropically
% dilated copies of a mother function. This one is set to the mexican hat.


%% Loading the initial image
clear all; close all;
load woman128
img = double(X);
PSNR = @(x,y) 20 * log10(256 / std(x(:) - y(:)));

imagesc(img); axis square; colormap(gray);
title('Initial Image: 128x128');

%% Decomposing the image using usual Matching Pursuit in a 
% dictionary made of translated, rotated and anisotropically dilated copies
% of the mexican hat mother function.
nb_atom = 300;
nbscales = 3; 
nbangles = 4;
ga_iter = 0;


fprintf('Dictionary contains %i elements\n', 128^2 * nbscales^2 * nbangles);
disp(['And now, let''s drink a coffee, excepted if you'...
    ' like spending time to look at a progression bar !']);
[atoms, resid, approx, eltime, qual_curve, quality] = ...
    mpdecomp_ga_2d(img, nb_atom, nbscales, nbangles, ga_iter);

figure;
imagesc(approx); axis square; colormap(gray);
title( sprintf(['MP Approximation in a dictionary made' ...
    ' of\n (J=%i)^2 scales, K=%i rotations: PSNR: %.2fdB'], ...
    nbscales, nbangles, PSNR(img, approx)));


%% Decomposing the image using the geometrically optimized MP in a very
% coarse dictionary made of translated, rotated and anisotropically dilated copies
% of the mexican hat mother function.
nb_atom = 300;
nbscales = 3; 
nbangles = 4;
ga_iter = 10;

[atoms, resid, approx, eltime, qual_curve, quality] = ...
    mpdecomp_ga_2d(img, nb_atom, nbscales, nbangles, ga_iter);

figure;
imagesc(approx); axis square; colormap(gray);
title( sprintf(['gMP Approximation (%i iter) in a dictionary made' ...
    ' of\n (J=%i)^2 scales, K=%i rotations: PSNR: %.2fdB'], ...
    ga_iter, nbscales, nbangles, PSNR(img, approx)));
