/* gen_mh_coptim : same as gen_mh.m but written in C for speed (+- 5 times faster) 
 *
 * The documentation is available in the corresponding M-file.
 *
 * \mansec{License}
 *
 * This file is part of YAW Toolbox (Yet Another Wavelet Toolbox)
 * You can get it at \url{"http://www.fyma.ucl.ac.be/projects/yawtb"}{"yawtb homepage"} 
 *
 * $$
 *
 * Copyright (C) 2001-2002, the YAWTB Team (see the file AUTHORS distributed with this library)
 * (See the notice at the end of the file.) */

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <mex.h>

/* Input data */

#define i_X     prhs[0] 
#define i_Y     prhs[1] 

#define i_p     prhs[2] 

#define i_narg  3

/* Output data */

#define o_out   plhs[0] 

/* Mexfunction == main */
void  mexFunction ( int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])  
{
  /* Input array (in C) */
  double *X, *Y, *p;
  double x, y, nX2, nY2, cX, cY;
  double sc1, sc2, ang, cang, sang;
  double *out, cwav, norm_out;
  
  int    i, nrow, ncol, siz;

  X   = mxGetPr(i_X);
  Y   = mxGetPr(i_Y);

  nrow = mxGetM(i_X);
  ncol = mxGetN(i_X);
  siz  = nrow*ncol;

  p  = mxGetPr(i_p);

  x = *(p + 0);
  y = *(p + 1);

  ang = *(p + 2);
  sc1 = *(p + 3);
  sc2 = *(p + 4);

  cang = cos(ang);
  sang = sin(ang);

  o_out = mxCreateDoubleMatrix (nrow, ncol, mxREAL);
  out   = mxGetPr(o_out);

  /********************************************************************************
   *                                 Computations                                 *
   ********************************************************************************/

  norm_out = 0;
  for(i = siz - 1; i >= 0; i--)
    {
      cX = *(X+i) - x;
      cY = *(Y+i) - y;
      nX2 = (cang*cX - sang*cY)/sc1;
      nX2 *= nX2;

      nY2 = (sang*cX + cang*cY)/sc2;
      nY2 *= nY2;
      
      /*cwav = (nX2 + nY2 > 2000) ? 0 : ((1 - nX2) * exp( - (nX2 + nY2)/2 ));*/
      cwav = (1 - nX2) * exp( - (nX2 + nY2)/2 );
      norm_out +=  cwav*cwav;
      *(out+i) = cwav;
    }

  norm_out = sqrt(norm_out);

  for(i = siz - 1; i >= 0; *(out+i) /= norm_out, i--);
  
} /* EndOf mexfunction */




/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */
