%% Loading the signal
load superpos
figure; plot(sig);                       
SNR = @(x, y) 20*log10(std(x(:))/std(x(:) - y(:)));

%% Decomposing the signal 'superpos' using 
% traditional Matching Pursuit (MP)
[atoms, Rl] = mpdecomp(sig, 300, 8);

figure; plot(Rl); title('MP Residue');   
figure; plot(sig-Rl); 
title(sprintf('MP Aproximation, SNR: %e', SNR(sig, sig-R1) );

%% Decomposing the signal with the geometrically optimized MP (or gMP)
% using a Gradient Ascent of the Manifold generated by the dictionary
[atoms, Rl] = mpdecomp_ga(sig, 300, 8, 100);

figure; plot(Rl); % Residue   
figure; plot(sig-Rl); % Aproximation