function wav = mex1d_lambda(t, lambda)
% Translate and dilate the mexican hat in time domain
% Inputs :
% * t : time domain (vector)
% * lambda = [position scale]

wav = mex1d((t - lambda(1))/lambda(2));
wav = wav / (norm(wav)*(t(2)-t(1))^.5);
