function [out] = mex1d_freq(w)
% Frequency shape of 1-D Mexican Hat

%% Normalisation comes from the book of Mallat p.148 times
%% (2*pi)^.5
%% Maximal dilation is around length(w)/4.

out =  (8/3)^.5*pi^.25 * w.^2 .* exp(- w.^2/2);
