function wav = gen_mh(X,Y, param)
% This function generate a mexican hat translated, rotated and dilated
% according to the values of the vector param
%
% Inputs:
% * X,Y : arrays of positions such as produced by meshggrid
% * param : vector of 5 parameters : 2 positions, 1 angle and two
%           dilations
% Output :
% * wav : the MH computed on the positions (X,Y)
    
    px = param(1);
    py = param(2);
    ang = param(3);
    sc1 = param(4);
    sc2 = param(5);
    
    Z = X + i*Y;
    p = px + i*py;
    
    nZ = (Z - p).*exp(i*ang);
    nX2 = (real(nZ)/sc1).^2;
    nY2 = (imag(nZ)/sc2).^2;
    
    wav = (1 - nX2) .* exp(- (nX2 + nY2)/2 );
    wav = wav ./ norm(wav(:));
    