function [xhat,info,objective] = func_CoBP_lambda(yq,A,delta,lambda,param_solver)
% Showing details of toolbox
verbose = 1;
%% Defining proximal operators

% setting parameters for function f1
param_l1.verbose=verbose - 1;

% setting function f1
f1.prox = @(x, T) prox_l1(x, T, param_l1);
f1.eval = @(x) norm(x,1);

% setting parameters for function f2
param_projb2.verbose = verbose - 1;
param_projb2.epsilon = 1;

% setting function f2
f2.prox = @(x,T) proj_b2(x, T, param_projb2);
f2.eval = @(x) eps;

% setting parameters for function f3
param_proj.A = @(x) A * x;
param_proj.At = @(x) A' * x;
param_proj.y = yq;
param_proj.tight = 0;
param_proj.nu = norm(A)^2;
param_proj.tol = 1e-8;
param_proj.maxit = 2000;
param_proj.verbose = verbose - 1;
param_proj.epsilon = delta/2;
param_proj.method = 'ISTA';

% setting function f3
f3.prox = @(x,T) proj_binf(x,T,param_proj);
f3.eval = @(x) eps;

% setting parameters for function f4
param_f4.epsilon = lambda;
param_f4.verbose=verbose - 1;

% setting function f4
f4.prox = @(x,T) proj_binf(x,T,param_f4);
f4.eval = @(x) eps;

%
%% solving the problem

% Solver
F = {f1,f2,f4,f3};

% possible user defined initialization point
if ~isfield(param_solver, 'init_pt'), param_solver.init_pt = zeros(size(A,2),1); end

[xhat,info,objective] = ppxa(param_solver.init_pt,F,param_solver);


