function func_plot(y,x,scenario)
limit = length(x);
close all
p.sparse.cobp= polyfit(log2(x),y.sparse.cobp(1:limit),1);
fit.sparse.cobp  = polyval(p.sparse.cobp,log2(x));

p.sparse.bpdn= polyfit(log2(x),y.sparse.bpdn(1:limit),1);
fit.sparse.bpdn  = polyval(p.sparse.bpdn,log2(x));

figure
plot(log2(x),y.sparse.cobp(1:limit),'k-o','linewidth',2); hold on
plot(log2(x),fit.sparse.cobp,'k--','linewidth',1);hold on

plot(log2(x),y.sparse.bpdn(1:limit),'r->','linewidth',2); hold on
plot(log2(x),fit.sparse.bpdn,'r--','linewidth',1);hold on

xlabel('log_2(M/K)')
ylabel('log_2(||x-x_o||)')
grid on
title(['Scenario ',num2str(scenario)])
legend('CoBP (Sparse signal)',['CoBP (Sparse signal) linear fit, slope = ',num2str(p.sparse.cobp(1))],...
    'BPDN (Sparse signal)',['BPDN (Sparse signal) linear fit, slope = ',num2str(p.sparse.bpdn(1))])