function s = admm1_alg()
s.name = 'ADMM1';
s.initialize = @(x_0, fg, Fp, param) admm_initialize(x_0,fg,Fp,param);
s.algorithm = @(x_0, fg, Fp, sol, s, param) admm_algorithm(Fp, s, param);
s.finalize = @(x_0, fg, Fp, sol, s, param) sol;

end

function [sol, s, param] = admm_initialize(x_0,fg,Fp,param)

if ~isfield(param, 'L'), param.L=@(x) x; end
if isa(param.L,'numeric')
    s.OpL= @(x) param.L*x;
else
    s.OpL= param.L;
end
s.x_n = {};
s.x_n{2}{1} = s.OpL(x_0);
s.x_n{3} =[];
s.u_n = zeros(size(s.x_n{2}{1}));
s.dual_var = s.x_n{2}{1};
sol = x_0;
if fg.beta
    error('ADMM needs only function with proximal operators')
end



param.abs_tol = 1;
param.use_dual = 1;


end


function [sol, s] = admm_algorithm(Fp, s, param)

s.x_n{1} = Fp{1}.prox_ad(s.x_n{2}{1} - s.u_n,param.gamma);
s_n= s .OpL(s.x_n{1}{1});
s.x_n{2} = Fp{2}.prox_ad(s_n+s.u_n,param.gamma);
s.x_n{3} = Fp{3}.prox_ad(s.x_n{1}{1}+s.u_n,param.gamma);
s.dual_var = s.x_n{2}{1};


s.u_n = s.u_n+s_n-s.x_n{2}{1} ;% updates
sol = s.x_n{1}{1};


end

%
%   Url: http://unlocbox.sourceforge.net/doc/solver/alg/admm_alg.php

% Copyright (C) 2012-2013 Nathanael Perraudin.
% This file is part of UNLOCBOX version 1.6.1
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

